import funkin.backend.system.Logs;
import funkin.backend.utils.CoolUtil;
import flixel.text.FlxText;
import flixel.text.FlxTextBorderStyle;
import funkin.game.PlayState;

// If set to true, will print some extra debug info in console.
var devMode:Bool = false;

// the text background (as using a border on the text instead made some weird artifacts)
var bg:FlxSprite;

// how much padding, both horizontally and vertically.
var bgPadding = {h: 5, v: 0};

// the text
var text:FlxText;

// the camera for bg+text
var camSub:FlxCamera;

// default text y
var defaultY:Float;

function postCreate() {
	if (!FlxG.save.data.subtitles_toggle)
		return;

	camSub = new FlxCamera(0, 0, FlxG.width, FlxG.height, 1);
	camSub.bgColor = 0x00000000;
	FlxG.cameras.add(camSub, false);

	text = new FlxText(0, 640, 0, "", 16);
	text.setFormat(Paths.font('vcr.ttf'), 32, 0xFFFFFF);
	text.cameras = [camSub];
	defaultY = text.y;

	bg = new FlxSprite().makeGraphic(1, 1, 0x80000000);
	bg.cameras = [camSub];
	add(bg);
	add(text);
}

// Options.downscroll ? 50 : FlxG.height - 50

function onEvent(__event) {
	if (!FlxG.save.data.subtitles_toggle)
		return;

	if (__event.event.name == "Change Subtitle") {
		var caption:String = __event.event.params[0];
		var color:Int = __event.event.params[1];
		var size:Int = __event.event.params[2];
		var font:String = "";
		var yOffset:Float = __event.event.params[4];
		var isVideoSub:Bool = __event.event.params[5];

		// Since the Y offset was added later, run a quick check to make sure we don't cause NULL-related crashes.
		if (yOffset == null) {
			yOffset = 0;
		}
		// and this. this was also added later in dev., so check for it.
		if (isVideoSub == null) {
			isVideoSub = false;
		}

		if (devMode)
			Logs.trace("SUBTITLE - caption: " + ((caption == "") ? "**clear**" : ("\"" + caption + "\"")) +
					   "\tcolor int: " + color +
					   "\tsize: " + size +
					   "\tfont: " + font +
					   "\ty offset: " + yOffset +
					   "\tis video? " + isVideoSub);

		if (isVideoSub && !FlxG.save.data.midsongvids_toggle) {
			if (devMode)
				trace("Cancelling subtitle - is a video-related sub and vids are disabled.");
			return;
		}

		switch (__event.event.params[3]) {
			case "Arial":
				font = "vcr.ttf";
			case "Comic Sans MS":
				font = "comic.ttf";
			case "DS BIOS":
				font = "DSbios.ttf";
			case "Segoe UI":
				font = "segoeUI.TTF";
			case "Mensa Condensed":
				font = "mensaCondensed.ttf";
			default:
				font = "vcr.ttf";
		}

		text.setFormat(Paths.font(font), size, color);
		text.text = caption;

		text.y = defaultY + yOffset;

		CoolUtil.cameraCenter(text, camSub, FlxAxes.X);
		text.updateHitbox();

		bg.visible = (text.text != "");
		if (caption != "") {
			bg.scale.x = text.width + bgPadding.h;
			bg.scale.y = text.height + bgPadding.v;
			bg.setPosition(text.x - (bgPadding.h / 2), text.y + (text.height / 2));
			CoolUtil.cameraCenter(bg, camSub, FlxAxes.X);
		}
	}
}

function destroy() {
	camSub.destroy();
}